/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.lonelyPeripherals;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import com.samsthenerd.duckyperiphs.DuckyPeriphs;
import com.samsthenerd.duckyperiphs.hexcasting.utils.IotaLuaUtils;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class AkashicBookshelfPeripheral
implements IPeripheral {
    private BlockEntityAkashicBookshelf bookshelf;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    AkashicBookshelfPeripheral(BlockEntityAkashicBookshelf _bookshelf) {
        this.bookshelf = _bookshelf;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        return "akashic_bookshelf";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final MethodResult readShelf() {
        return MethodResult.of(AkashicBookshelfPeripheral.shelfData(this.bookshelf));
    }

    public static Map<String, Object> shelfData(BlockEntityAkashicBookshelf bookshelf) {
        Object iotaObject;
        class_2487 tag = bookshelf.getIotaTag();
        class_1937 world = bookshelf.method_10997();
        NullIota iota = new NullIota();
        if (world instanceof class_3218) {
            class_3218 sworld = (class_3218)world;
            iotaObject = IotaLuaUtils.getLuaObject(tag, sworld);
            if (tag != null) {
                iota = IotaType.deserialize((class_2487)tag, (class_3218)sworld);
            }
        } else {
            DuckyPeriphs.logPrint("reading iota in client world");
            iotaObject = IotaLuaUtils.getLuaObject(tag, null);
        }
        HashMap<String, Object> returnTable = new HashMap<String, Object>();
        returnTable.put("patternKey", IotaLuaUtils.getLuaObject(bookshelf.getPattern()));
        returnTable.put("shelfIota", iotaObject);
        returnTable.put("shelfIotaType", IotaLuaUtils.getIotaTypeID(iota.getType()));
        return returnTable;
    }
}

